﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class ProgressBar : MonoBehaviour
{
    //Public properties
    public bool RenderPercentage;

    //UI elements
    public Slider Slider;
    public TMP_Text PercentageText;

    private void Update()
    {
        //Update the percentage based on the properties
        if(RenderPercentage)
        {
            PercentageText.text = (Slider.value * 100.0f) + "%";
            PercentageText.enabled = true;
        }   
        
        else
        {
            PercentageText.enabled = false;
        }
    }

    /// <summary>
    /// Sets the slider value based on a percentage (value is between 0 - 1)
    /// </summary>
    /// <param name="percentage">The percentage to set</param>
    public void SetProgressPercentage(int percentage)
    {
        Slider.value = ((float)percentage / 100.0f);
    }
}
